#include "queries.hpp"
#include "furita/common/rule.hpp"
#include "furita/common/rule_helper.hpp"

#include <sharpei_client/sharpei_client.h>
#include <pgg/factory.h>
#include <pgg/service/uid_resolver.h>

namespace furita {
namespace pq {
struct NotVerifiedParamsHandler : boost::enable_shared_from_this<NotVerifiedParamsHandler> {
    void HandleNotVerifiedParams(pgg::error_code ec, const std::vector<reflection::NotVerifiedParams>& res,
                                 promise<std::map<uint64_t, std::pair<std::string, std::string>>> prom) {
        if (ec) {
            prom.set_exception(pgg::system_error(ec));
        } else {
            std::map<uint64_t, std::pair<std::string, std::string>> params;
            for (const auto& record : res) {
                params[record.action_id] = std::make_pair(record.param, record.oper);
            }
            prom.set(params);
        }
    }
};

}
}
