#include "queries.hpp"
#include "furita/common/rule.hpp"

#include <sharpei_client/sharpei_client.h>
#include <pgg/factory.h>
#include <pgg/service/uid_resolver.h>

namespace furita {
namespace pq {
struct GetRuleHandler : boost::enable_shared_from_this<GetRuleHandler> {
    void HandleGetRule(pgg::error_code ec, const std::vector<reflection::Rule>& res, promise<rules::rule_list_ptr> prom, const uint64_t rule_id) {
        if (ec) {
            prom.set_exception(pgg::system_error(ec));
        } else if (res.size() > 1) {
            prom.set_exception(yplatform::exception("Error", "More than one rule get by id: " + std::to_string(rule_id)));
        } else {
            rules::rule_list_ptr r_list = boost::make_shared<rules::rule_list>();
            for (const auto& record : res) {
                rules::rule_ptr r = boost::make_shared<rules::rule>();
                r->id = record.rule_id;
                r->name = record.name;
                r->enabled = record.enabled;
                r->prio = record.prio;
                r->stop = record.stop;
                r->created = record.created;
                r->type = record.type;
                r_list->push_back(r);
            }
            prom.set(r_list);
        }
    }
};

struct GetRulesHandler : boost::enable_shared_from_this<GetRulesHandler> {
    void HandleGetRules(pgg::error_code ec, const std::vector<reflection::Rule>& res, promise<rules::rule_list_ptr> prom) {
        if (ec) {
            prom.set_exception(pgg::system_error(ec));
        } else {
            rules::rule_list_ptr r_list = boost::make_shared<rules::rule_list>();
            for (const auto& record : res) {
                rules::rule_ptr r = boost::make_shared<rules::rule>();
                r->id = record.rule_id;
                r->name = record.name;
                r->enabled = record.enabled;
                r->prio = record.prio;
                r->stop = record.stop;
                r->created = record.created;
                r->type = record.type;
                r_list->push_back(r);
            }
            prom.set(r_list);
        }
    }
};

}
}
