#pragma once

#include "sharpei_http_client.hpp"

#include <pgg/database/pool_factory.h>
#include <pgg/request_executor.h>
#include <furita/common/context.h>
#include <furita/pq/pq.hpp>
#include <furita/pq/logging.hpp>
#include <sharpei_client/sharpei_client.h>

#include <memory>

namespace furita {
namespace pq {
class impl: public pq {
public:
    impl();
    virtual ~impl();

    void init(const yplatform::ptree& xml);
    void fini();

    future<boost::unordered_map<uint64_t, RulesResult>>
    get_rules_multiuser(
        const TContextPtr& ctx,
        const std::vector<uint64_t>& uid,
        sharpei::client::Mode mode) override;

    future<rules::rule_list_ptr> get_rule(pgg::RequestExecutor& executor,
                                          const uint64_t& user,
                                          const uint64_t& id) override;

    future<rules::rule_list_ptr> get_all_rules(
        pgg::RequestExecutor& executor,
        const uint64_t& uid) override;

    future<rules::rule_list_ptr> get_rules_by_type(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const rules_helpers::RuleType &type) override;

    future<void> remove_rules(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const std::vector<uint64_t>& ids) override;

    future<void> enable_rule(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const uint64_t& id, bool enabled) override;

    future<rules::condition_list_ptr> get_rule_conditions(
        pgg::RequestExecutor& executor,
        const uint64_t& uid, const uint64_t& rule_id) override;

    future<rules::condition_list_ptr> get_all_conditions(
        pgg::RequestExecutor& executor,
        const uint64_t& uid) override;

    future<rules::action_list_ptr> get_rule_actions(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const uint64_t& rule_id) override;

    future<rules::action_list_ptr> get_all_actions(
        pgg::RequestExecutor& executor,
        const uint64_t& uid) override;

    future<rules::action_list_ptr> get_action(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const uint64_t& action_id) override;

    future<bool> order_rule(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const std::vector<uint64_t>& ids) override;

    future<void> verify_rule(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const uint64_t& id) override;

    future<void> edit_rule(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const rules::rule_ptr& rule, const boost::optional<uint64_t>& old_id, bool last) override;

    future<std::map<uint64_t, std::pair<std::string, std::string>>> get_not_verified_parameters(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const uint64_t& id) override;

    future<uint64_t> get_new_rule_id(
        pgg::RequestExecutor& executor,
        const uint64_t& uid) override;

    future<rules::blacklist_ptr> get_all_lists(
        pgg::RequestExecutor& executor,
        const uint64_t& uid) override;

    future<rules::blacklist_ptr> get_list_by_type(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const std::string& type) override;

    future<void> remove_from_list(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const std::vector<std::string>& emails,
        const std::string& type) override;

    future<void> add_to_list(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const std::string& email,
        const std::string& type) override;

    pgg::SharpeiParams create_sharpei_params(const TContextPtr& ctx) override;

    pgg::RequestExecutor create_request_executor(const TContextPtr& ctx,
                                                         const uint64_t& id,
                                                         const pgg::UidResolverFactoryPtr& resolverFactory,
                                                         sharpei::client::Mode mode) override;

private:

    pgg::ConnectionPoolPtr pool;
    pgg::query::RepositoryPtr query_conf;
    std::string dbuser;
    SharpeiOptions sharpei_conf;
};

}
}
