#pragma once

#include <pgg/query/ids.h>
#include <pgg/query/boundaries.h>
#include <pgg/query/query_register.h>

PGG_QUERY_ID((furita)(pq)(query), Uid, uint64_t)
PGG_QUERY_ID((furita)(pq)(query), RuleId, uint64_t)
PGG_QUERY_ID((furita)(pq)(query), ActionId, uint64_t)
PGG_QUERY_ID((furita)(pq)(query), Uids, std::vector<uint64_t>)
PGG_QUERY_ID((furita)(pq)(query), RuleType, std::string)
PGG_QUERY_ID((furita)(pq)(query), RulesIds, std::vector<uint64_t>)
PGG_QUERY_ID((furita)(pq)(query), RuleName, std::string)
PGG_QUERY_ID((furita)(pq)(query), RuleEnabled, bool)
PGG_QUERY_ID((furita)(pq)(query), RuleStop, bool)
PGG_QUERY_ID((furita)(pq)(query), RuleLast, bool)
PGG_QUERY_ID((furita)(pq)(query), RuleConds, std::vector<std::string>)
PGG_QUERY_ID((furita)(pq)(query), RuleActs, std::vector<std::string>)
PGG_QUERY_ID((furita)(pq)(query), RuleNewId, boost::optional<uint64_t>)
PGG_QUERY_ID((furita)(pq)(query), RuleOldId, boost::optional<uint64_t>)
PGG_QUERY_ID((furita)(pq)(query), ListType, std::string)
PGG_QUERY_ID((furita)(pq)(query), Email, std::string)
PGG_QUERY_ID((furita)(pq)(query), Emails, std::vector<std::string>)

BOOST_FUSION_DEFINE_STRUCT((furita)(pq)(reflection),
    UnionRuleConditionAction,
    (std::uint64_t, uid)
    (std::uint64_t, rule_id)
    (boost::optional<std::string>, name)
    (boost::optional<bool>, enabled)
    (boost::optional<std::int64_t>, prio)
    (boost::optional<bool>, stop)
    (boost::optional<std::time_t>, created)
    (boost::optional<std::string>, type)
    (boost::optional<std::string>, field_type)
    (boost::optional<std::string>, field)
    (boost::optional<std::string>, pattern)
    (boost::optional<std::string>, condition_oper)
    (boost::optional<std::string>, link)
    (boost::optional<bool>, negative)
    (boost::optional<std::uint64_t>, action_id)
    (boost::optional<std::string>, action_oper)
    (boost::optional<std::string>, param)
    (boost::optional<bool>, verified)
)

BOOST_FUSION_DEFINE_STRUCT((furita)(pq)(reflection),
    Rule,
    (std::uint64_t, rule_id)
    (std::string, name)
    (bool, enabled)
    (std::int64_t, prio)
    (bool, stop)
    (std::time_t, created)
    (std::string, type)
)

BOOST_FUSION_DEFINE_STRUCT((furita)(pq)(reflection),
    Condition,
    (std::uint64_t, rule_id)
    (std::string, field_type)
    (std::string, field)
    (std::string, pattern)
    (std::string, oper)
    (std::string, link)
    (bool, negative)
)

BOOST_FUSION_DEFINE_STRUCT((furita)(pq)(reflection),
    Action,
    (std::uint64_t, rule_id)
    (std::uint64_t, action_id)
    (std::string, oper)
    (std::string, param)
    (bool, verified)
)

BOOST_FUSION_DEFINE_STRUCT((furita)(pq)(reflection),
    ListEntry,
    (std::string, list)
    (std::string, email)
    (std::time_t, created)
)

BOOST_FUSION_DEFINE_STRUCT((furita)(pq)(reflection),
    RulesOrderResult,
    (bool, order_rules_with_check)
)

BOOST_FUSION_DEFINE_STRUCT((furita)(pq)(reflection),
    NewRuleId,
    (std::uint64_t, nextval)
)

BOOST_FUSION_DEFINE_STRUCT((furita)(pq)(reflection),
    NotVerifiedParams,
    (std::uint64_t, action_id)
    (std::string, param)
    (std::string, oper)
)

namespace furita {
namespace pq {
namespace query {
using pgg::query::QueryImpl;

struct GetRuleConditions : QueryImpl<GetRuleConditions, Uid, RuleId> {
    using Inherited::Inherited;
};

struct GetAllConditions : QueryImpl<GetAllConditions, Uid> {
    using Inherited::Inherited;
};

struct GetAction : QueryImpl<GetAction, Uid, ActionId> {
    using Inherited::Inherited;
};

struct GetRuleActions : QueryImpl<GetRuleActions, Uid, RuleId> {
    using Inherited::Inherited;
};

struct GetAllActions : QueryImpl<GetAllActions, Uid> {
    using Inherited::Inherited;
};

struct GetRule : QueryImpl<GetRule, Uid, RuleId> {
    using Inherited::Inherited;
};

struct GetAllRules : QueryImpl<GetAllRules, Uid> {
    using Inherited::Inherited;
};

struct GetAllRulesMultiuser : QueryImpl<GetAllRulesMultiuser, Uids> {
    using Inherited::Inherited;
};

struct GetRulesByType : QueryImpl<GetRulesByType, Uid, RuleType> {
    using Inherited::Inherited;
};

struct GetNewRuleId : QueryImpl<GetNewRuleId> {
    using Inherited::Inherited;
};

struct GetNotVerifiedParams : QueryImpl<GetNotVerifiedParams, Uid, RuleId> {
    using Inherited::Inherited;
};

struct RemoveRules : QueryImpl<RemoveRules, Uid, RulesIds> {
    using Inherited::Inherited;
};

struct EnableRule : QueryImpl<EnableRule, Uid, RuleId> {
    using Inherited::Inherited;
};

struct DisableRule : QueryImpl<DisableRule, Uid, RuleId> {
    using Inherited::Inherited;
};

struct RuleOrderWithCheck : QueryImpl<RuleOrderWithCheck, Uid, RulesIds> {
    using Inherited::Inherited;
};

struct VerifyRule : QueryImpl<VerifyRule, Uid, ActionId> {
    using Inherited::Inherited;
};

struct RuleEdit : QueryImpl<RuleEdit, Uid, RuleName, RuleEnabled, RuleStop, RuleLast, RuleActs, RuleConds, RuleOldId, RuleNewId, RuleType> {
    using Inherited::Inherited;
};

struct GetAllLists : QueryImpl<GetAllLists, Uid> {
    using Inherited::Inherited;
};

struct GetListByType : QueryImpl<GetListByType, Uid, ListType> {
    using Inherited::Inherited;
};

struct AddToList : QueryImpl<AddToList, Uid, ListType, Email> {
    using Inherited::Inherited;
};

struct RemoveFromList : QueryImpl<RemoveFromList, Uid, ListType, Emails> {
    using Inherited::Inherited;
};


using QueriesRegister = pgg::query::RegisterQueries<
    GetRuleConditions,
    GetAllConditions,
    GetAction,
    GetRuleActions,
    GetAllActions,
    GetRule,
    GetAllRules,
    GetAllRulesMultiuser,
    GetRulesByType,
    GetNewRuleId,
    GetNotVerifiedParams,
    RemoveRules,
    EnableRule,
    DisableRule,
    RuleOrderWithCheck,
    VerifyRule,
    RuleEdit,
    GetAllLists,
    GetListByType,
    AddToList,
    RemoveFromList>;

using ParametersRegister = pgg::query::RegisterParameters<>;

} //namespace query
} //namespace pq
} //namespace furita
