#include <boost/date_time/posix_time/posix_time.hpp>
#include <yplatform/log.h>
#include "configuration.h"

using namespace furita::processor;

void usettings_options::load(const yplatform::ptree& xml)
{
    primary_host = xml.get<std::string>("primary");
    fallback_host = xml.get<std::string>("fallback");
    attempts = xml.get<unsigned short>("attempts", 1);
    timeouts.connect = xml.get("connect_timeout", timeouts.connect);
    timeouts.total = xml.get("request_timeout", timeouts.total);

    L_(info) << "ymod_furita_processor: usettings"
        << " primary host=" << primary_host
        << ", fallback host=" << fallback_host;
}

void configuration::load_mops_options(const yplatform::ptree& xml)
{
    mops.primary_host = xml.get<std::string>("primary");
    mops.fallback_host = xml.get<std::string>("fallback");
    mops.attempts = xml.get<unsigned short>("attempts", 1);
    mops.connectTimeout = xml.get("connect_timeout", mops.connectTimeout);
    mops.requestTimeout = xml.get("request_timeout", mops.requestTimeout);
    mops.log_pa_ = xml.get<unsigned int>("log_pa", 0);

    L_(info) << "ymod_furita_processor: mops"
        << " primary host=" << mops.primary_host
        << ", fallback host=" << mops.fallback_host;
}

void MidSearchOptions::init(const yplatform::ptree& xml) {
    fetchUrl = xml.get<std::string>("fetch_url");
    fetchLimit = xml.get<std::size_t>("fetch_limit", 999999999);
    folderSet = xml.get<std::string>("folder_set", "");
    attempts = xml.get<unsigned short>("attempts", 4);
    timeouts.connect = xml.get("connect_timeout", timeouts.connect);
    timeouts.total = xml.get("request_timeout", timeouts.total);
}

void SoCheckOptions::init(const yplatform::ptree& ptree) {
    use = ptree.get<bool>("use");
    dry_run = ptree.get<bool>("dry_run");
    url = ptree.get<std::string>("url");
    form_realpath = ptree.get<std::string>("form_realpath");
}
