#pragma once

#include <string>
#include <map>
#include <boost/shared_ptr.hpp>
#include <yplatform/ptree.h>
#include <yplatform/time_traits.h>
#include <ymod_httpclient/call.h>
#include <ymod_smtpclient/smtp_point.h>
#include <sharpei_client/sharpei_client.h>
#include "mops_call_options.hpp"

namespace furita {
namespace processor {

struct message_templates
{
    bool empty() const
    {
        return m_templates.empty();
    }

    static std::string build_key_param(const std::string &action,
        const std::string &lang)
    {
        return action + "_" + lang;
    }

    const std::string & find(const std::string &action, const std::string &lang,
        const std::string &def_action, const std::string &def_lang) const
    {
        static const std::string empty_template;
        std::map<std::string, std::string>::const_iterator t =
            m_templates.find(build_key_param(action, lang));
        if (t != m_templates.end())
            return t->second;

        t = m_templates.find(build_key_param(action, def_lang));
        if (t != m_templates.end())
            return t->second;

        t = m_templates.find(build_key_param(def_action, lang));
        if (t != m_templates.end())
            return t->second;

        t = m_templates.find(build_key_param(def_action, def_lang));
        if (t != m_templates.end())
            return t->second;

        return empty_template;
    }

    std::map<std::string, std::string> m_templates;
};

struct usettings_options {
    void load(const yplatform::ptree& xml);

    std::string primary_host;
    std::string fallback_host;
    unsigned short attempts = 1;
    ymod_httpclient::timeouts timeouts;
};

struct MidSearchOptions {
    void init(const yplatform::ptree& xml);

    std::size_t fetchLimit = 999999999;
    std::string fetchUrl;
    std::string folderSet;
    unsigned short attempts = 4;
    ymod_httpclient::timeouts timeouts;
};

struct SoCheckOptions {
    void init(const yplatform::ptree& ptree);

    bool use;
    bool dry_run;
    std::string url;
    std::string form_realpath;
};

struct configuration
{
    void load_mops_options(const yplatform::ptree& xml);

    MidSearchOptions searchOptions;

    message_templates filter_confirm_templates;

    std::string shortener_url;

    usettings_options usettings;

    SoCheckOptions so_check_options;

    std::string settings_url;
    bool use_oracle;
    std::string allow_forward;

    mops_call_options mops;
    bool log_pa;

    ymod_smtpclient::SmtpPoint smtpAddr;
};

typedef boost::shared_ptr<configuration> configuration_ptr;

}   // namespace processor
}   // namespace furita

