#pragma once

#include <furita/common/context.h>

#include <ymod_httpclient/call.h>
#include <yplatform/find.h>

namespace furita {

class HttpClient {
public:
    virtual ~HttpClient() {}

    virtual ymod_httpclient::future_void_t post(
        TContextPtr ctx,
        const std::string& host,
        const ymod_httpclient::timeouts& timeouts,
        const std::string& url,
        ymod_httpclient::string_ptr data,
        const ymod_httpclient::headers_dict& headers,
        yhttp::response_handler_ptr handler
    ) const = 0;

    virtual ymod_httpclient::future_void_t get(
        TContextPtr ctx,
        const std::string& host,
        const ymod_httpclient::timeouts& timeouts,
        const std::string& url,
        const ymod_httpclient::headers_dict& headers,
        yhttp::response_handler_ptr handler
    ) const = 0;
};

using HttpClientPtr = std::shared_ptr<HttpClient>;

std::string headersToString(const ymod_httpclient::headers_dict& headers);

class HttpClientImpl: public HttpClient {
public:
    virtual ymod_httpclient::future_void_t post(
        TContextPtr ctx,
        const std::string& host,
        const ymod_httpclient::timeouts& timeouts,
        const std::string& url,
        ymod_httpclient::string_ptr data,
        const ymod_httpclient::headers_dict& headers,
        yhttp::response_handler_ptr handler
    ) const override {
        auto call = yplatform::find<yhttp::call>("http_client");
        auto rmInfo = call->make_rm_info(host, timeouts);
        return call->post_url(ctx->CreateTaskContext(), handler, rmInfo, url, data, headersToString(headers));
    };

    virtual ymod_httpclient::future_void_t get(
        TContextPtr ctx,
        const std::string& host,
        const ymod_httpclient::timeouts& timeouts,
        const std::string& url,
        const ymod_httpclient::headers_dict& headers,
        yhttp::response_handler_ptr handler
    ) const override {
        auto call = yplatform::find<yhttp::call>("http_client");
        auto rmInfo = call->make_rm_info(host, timeouts);
        return call->get_url(ctx->CreateTaskContext(), handler, rmInfo, url, headersToString(headers));
    };
};

} // namespace
