#define BOOST_SPIRIT_THREADSAFE
#include <boost/property_tree/xml_parser.hpp>
#include <boost/property_tree/json_parser.hpp>
#include <boost/tokenizer.hpp>
#include <contrib/libs/yajl/api/yajl_parse.h>
#include <yplatform/find.h>
#include <yplatform/exception.h>
#include <yplatform/encoding/url_encode.h>
#include <ymod_httpclient/call.h>
#include <ymod_blackbox/auth.h>
#include <furita/pq/pq.hpp>
#include "impl.h"

namespace furita {
namespace processor {

typedef yplatform::future::promise<std::string> promise_string;

void load_message_template(const std::string &path, std::string &message)
{
    std::ifstream file(path.c_str());
    if (file.good())
    {
        int c;
        message.reserve(10000);
        while ((c = file.get()) != -1)
            message += static_cast<char>(c);
    }
}

impl::impl() : m_configuration(new configuration)
{
    L_(info) << "furita_processor task instantiated";
}

impl::~impl()
{
    L_(info) << "furita_processor task destroyed";
}

void impl::init(const yplatform::ptree &xml)
{
    m_configuration->searchOptions.init(xml.get_child("search"));
    m_configuration->so_check_options.init(xml.get_child("so_check_filter"));

    m_configuration->use_oracle = xml.get<unsigned int>("use_oracle", 0);
    m_configuration->usettings.load(xml.get_child("usettings"));
    m_configuration->load_mops_options(xml.get_child("mops"));
    m_configuration->log_pa = xml.get<unsigned int>("log_pa", 0);
    m_configuration->shortener_url =
        xml.get<std::string>("shortener_url",std::string());
    m_configuration->allow_forward = xml.get<std::string>("allow_forward","all");
    m_configuration->smtpAddr = ymod_smtpclient::SmtpPoint::fromString(xml.get<std::string>("smtp_addr"));

    const auto& filterConfirmTemplates = xml.get_child("filter_confirm_templates");
    for (const auto& filterTemplate: filterConfirmTemplates) {
        if (filterTemplate.first != "template") {
            continue;
        }
        auto action = filterTemplate.second.get<std::string>("action");
        auto language = filterTemplate.second.get<std::string>("language");
        auto actionLang = message_templates::build_key_param(action, language);
        auto path = filterTemplate.second.get<std::string>("path");
        std::string message;
        load_message_template(path, message);
        m_configuration->filter_confirm_templates.m_templates.emplace(
            std::move(actionLang), std::move(message)
        );
    }
}

void impl::fini()
{}

const SoCheckOptions& impl::get_so_check_options() const {
    return m_configuration->so_check_options;
}

}   // namespace processor
}   // namespace furita

#include <yplatform/module_registration.h>

DEFINE_SERVICE_OBJECT(furita::processor::impl)
