#pragma once

#include <furita/common/context.h>
#include <furita/processor/processor.hpp>
#include <memory>
#include "configuration.h"

namespace furita {
namespace processor {

class impl : public processor
{
public:
    impl();
    virtual ~impl();

    void init(const yplatform::ptree& xml);
    void fini();

    future<std::vector<std::string>> preview(
        const TContextPtr& context,
        const uint64_t& uid,
        const uint64_t& id,
        unsigned int length,
        unsigned int offset,
        const std::string& remote_ip,
        const std::string& tvm,
        const ymod_httpclient::headers_dict& headers = {}) override;

    future<std::vector<std::string>> preview(
        const TContextPtr& context,
        const uint64_t& uid,
        const rules::rule_ptr& rule,
        unsigned int length,
        unsigned int offset,
        const std::string& remote_ip,
        const std::string& tvm,
        const ymod_httpclient::headers_dict& headers = {}) override;

    future<void> apply(
        const TContextPtr& context,
        const uint64_t& uid,
        const uint64_t& id,
        bool master,
        const std::string& remote_ip,
        const std::string& tvm,
        const ymod_httpclient::headers_dict& headers = {}) override;

    future<std::pair<status_result, boost::optional<uint64_t>>> rule_edit(
        const TContextPtr& ctx,
        const uint64_t& uid,
        const boost::optional<uint64_t>& id,
        const rules::rule_ptr& rule,
        bool last,
        const std::string& from,
        const std::string& lang,
        const std::string& confirm_domain,
        const std::string& auth_domain) override;

    const SoCheckOptions& get_so_check_options() const;

private:
    configuration_ptr m_configuration;

    struct PreviewHandler;
    struct ApplyHandler;
};

using ImplPtr = std::shared_ptr<impl>;

}   // namespace processor
}   // namespace furita

