#pragma once

#include <string>
#include <vector>
#include <deque>
#include <boost/noncopyable.hpp>
#include <yplatform/future/future.hpp>
#include <yplatform/task_context.h>
#include "mops_call_options.hpp"
#include "http_client.hpp"
#include <furita/common/context.h>
#include <furita/common/types.h>
#include <ymod_tvm/module.h>

namespace furita {
using yplatform::future::future;
using yplatform::future::promise;

class mops_call: private boost::noncopyable {
public:
    using MidList = std::vector<std::string>;

    using options = mops_call_options;

    explicit mops_call(TContextPtr ctx, HttpClientPtr httpClient,
                       const std::string& tvm, const ymod_httpclient::headers_dict& headers,
                       TTvmModulePtr tvmModule);

    future<void> move(
        const options& opt,
        const uint64_t& uid,
        const MidList& mids,
        const std::string& fid);

    future<void> remove(
        const options& opt,
        const uint64_t& uid,
        const MidList& mids);

    future<void> mark(
        const options& opt,
        const uint64_t& uid,
        const MidList& mids,
        const std::string& status);

    future<void> label(
        const options& opt,
        const uint64_t& uid,
        const MidList& mids,
        const std::vector<std::string>& lids);

private:
    TContextPtr ctx_;
    HttpClientPtr httpClient_;
    const std::string tvm_;
    const ymod_httpclient::headers_dict headers_;
    TTvmModulePtr tvmModule_;
};

}
