#pragma once

#include <deque>
#include <string>
#include <memory>
#include <yplatform/future/future.hpp>
#include <yplatform/task_context.h>
#include <ymod_httpclient/call.h>
#include <ymod_tvm/module.h>
#include "http_client.hpp"
#include <furita/common/context.h>
#include <furita/common/types.h>
#include <furita/common/rule_helper.hpp>

namespace furita {
using yplatform::future::future;
using yplatform::future::promise;

struct Envelopes {
    std::vector<std::string> envelopes;
};

class MsearchCall: public std::enable_shared_from_this<MsearchCall> {
public:

    explicit MsearchCall(
        TContextPtr ctx,
        HttpClientPtr httpClient,
        const std::string& url,
        const ymod_httpclient::headers_dict& headers,
        const ymod_httpclient::timeouts& timeouts,
        const std::string& tvm,
        TTvmModulePtr tvmModule
    )
        : ctx(ctx)
        , httpClient(httpClient)
        , url(url)
        , headers(headers)
        , timeouts(timeouts)
        , tvm(tvm)
        , tvmModule(std::move(tvmModule))
    {}

    TContextPtr context() const { return ctx; }

    future<void> search(
        const std::string& suid,
        const std::string& uid,
        const std::string& query,
        std::size_t offset,
        std::size_t length,
        const std::string& remote_ip,
        const std::string& folderSet,
        bool log_pa = false);

    std::vector<std::string>& mids() { return envelopes.envelopes; }

private:
    TContextPtr ctx;
    HttpClientPtr httpClient;
    std::string url;
    ymod_httpclient::headers_dict headers;
    ymod_httpclient::timeouts timeouts;
    const std::string tvm;
    TTvmModulePtr tvmModule;
    Envelopes envelopes;

    ymod_httpclient::headers_dict make_headers(std::string serviceTicket) const;
};

using MsearchCallPtr = std::shared_ptr<MsearchCall>;

} // namespace furita

BOOST_FUSION_ADAPT_STRUCT(furita::Envelopes,
    (std::vector<std::string>, envelopes)
)
