#pragma once

#include <furita/common/context.h>
#include <furita/common/rule.hpp>
#include <yplatform/task_context.h>
#include <ymod_httpclient/cluster_client.h>
#include <string>


namespace furita::processor::so_check {

enum EResult {
    OK,
    SPAM,
    ERROR
};

struct TParams {
    std::string user_ip;
    std::string user_uid;
    std::string form_realpath;
    std::string url;
};

std::string get_url(const std::string& url_prefix, const std::string& uid);

yplatform::future::future<EResult> so_check_filter(TContextPtr ctx, rules::rule_ptr rule,
        std::shared_ptr<yhttp::cluster_client> cluster_client, const TParams& params);

struct TFormField {
    std::string type;
    std::string filled_by;
    std::string value;
};

struct TRequest {
    using form_fields_type = std::map<std::string, furita::processor::so_check::TFormField>;

    std::string client_ip;
    std::string form_type;
    std::string form_realpath;
    std::string form_author;
    std::string subject;
    form_fields_type form_fields;

    void add_condition(TFormField&& condition);
    void add_action(TFormField&& action);

private:
    int list_add_action_number = 0;
    int list_add_condition_number = 0;
};

} // namespace furita::processor::so_check
