#include "verification_token.h"

#include <mail/yplatform/include/yplatform/encoding/base64.h>

#include <boost/format.hpp>

#include <library/cpp/openssl/holders/evp.h>

namespace furita::processor {

void encrypt(const std::string &in, std::vector<unsigned char> &out, const std::string &key, const std::string &iv)
{
    int length = 0, final_length = 0;
    out.resize(in.size() + EVP_CIPHER_block_size(EVP_bf_cbc()) + 1024);
    NOpenSSL::TEvpCipherCtx ctx;
    EVP_EncryptInit_ex(ctx, EVP_bf_cbc(), NULL, reinterpret_cast<const unsigned char *>(key.c_str()), reinterpret_cast<const unsigned char *>(iv.c_str()));
    EVP_EncryptUpdate(ctx, &out[0], &length, reinterpret_cast<const unsigned char *>(in.data()), static_cast<int>(in.size()));
    EVP_EncryptFinal_ex(ctx, &out[length], &final_length);
    out.resize(length + final_length);
}

std::string make_token(uint64_t id, uint64_t uid, const std::string &m_from)
{
    const std::string key("FilterRequestKey"), iv("Anything");
    std::vector<unsigned char> in;
    encrypt((boost::format("%1%:%2%:%3%:%4%") %
        (time(NULL) + 24 * 60 * 60) % id % m_from % uid).str(),
        in, key, iv);

    return yplatform::base64_encode_str(in);
}

} // namespace furita::processor
