from library.python.testing.recipe import declare_recipe
from yatest.common import work_path, build_path, source_path
from mail.unistat.cpp.cython.canonize.recipe import (
    find_free_port,
    extract_resources_to_work_path,
    patch_log_file_names,
    start_unistat,
    stop_unistat
)


def start_service_unistat(argv):
    port = find_free_port()

    config_path = work_path('config.yml')
    script_path = source_path('mail/furita/unistat/cython/furita_unistat.py')
    unistat_cmd = f"{build_path('mail/furita/unistat/cython/cunistat')} {script_path}" \
                  f" -d {work_path('')}" \
                  f" -H '::' -p {str(port)}" \
                  f" -l {work_path('unistat.log')}" \
                  f" {config_path}"

    _, logs = extract_resources_to_work_path()
    patch_log_file_names(config_path, logs)

    start_unistat(script_path, unistat_cmd, logs, port, files_is_data_files=False)


if __name__ == "__main__":
    declare_recipe(start_service_unistat, stop_unistat)
