#pragma once

#include <pgg/query/ids.h>
#include <pgg/query/boundaries.h>
#include <pgg/query/query_register.h>


BOOST_FUSION_DEFINE_STRUCT((furita)(reflection), Revision,
    (std::int32_t, revision)
)

BOOST_FUSION_DEFINE_STRUCT((furita)(reflection), DomainRules,
    (std::int64_t, org_id)
    (std::int32_t, revision)
    (std::string, rules)
)

BOOST_FUSION_DEFINE_STRUCT((furita)(reflection), OptionalDomainRules,
   (boost::optional<furita::reflection::DomainRules>, domainRules)
)

BOOST_FUSION_DEFINE_STRUCT((furita)(reflection), RequestInfo,
    (std::int64_t, org_id)
    (std::string, request_id)
)

PGG_QUERY_ID((furita)(query), OrgId, std::int64_t)
PGG_QUERY_ID((furita)(query), Revision, std::int32_t)
PGG_QUERY_ID((furita)(query), Rules, std::string)
PGG_QUERY_ID((furita)(query), RequestInfo, furita::reflection::RequestInfo)


namespace furita::query {

struct SetDomainRules : pgg::query::QueryImpl<SetDomainRules, RequestInfo, Rules> {
    using Inherited::Inherited;
};

struct GetDomainRules : pgg::query::QueryImpl<GetDomainRules, OrgId> {
    using Inherited::Inherited;
};

using QueriesRegister = pgg::query::RegisterQueries<
    SetDomainRules,
    GetDomainRules
>;

using ParametersRegister = pgg::query::RegisterParameters<>;

} // namespace furita::query
