#pragma once

#include <mail/furita/include/furita/core/types.h>

#include <io_result/io_result.h>
#include <io_result/hooks.h>

#include <memory>


namespace furita {

using OnSetDomainRules = io_result::Hook<Revision>;
using OnGetDomainRules = io_result::Hook<io_result::Optional<DomainRules>>;

struct Repository {
    virtual ~Repository() = default;

    template <typename Handler>
    auto setDomainRules(const SetDomainRulesParams& params, Handler handler) const {
        io_result::detail::init_async_result<Handler, OnSetDomainRules> init(handler);
        asyncSetDomainRules(params, init.handler);
        return init.result.get();
    }

    template <typename Handler>
    auto getDomainRules(const GetDomainRulesParams& params, Handler handler) const {
        io_result::detail::init_async_result<Handler, OnGetDomainRules> init(handler);
        asyncGetDomainRules(params, init.handler);
        return init.result.get();
    }

protected:
    virtual void asyncSetDomainRules(const SetDomainRulesParams& params, OnSetDomainRules handler) const = 0;
    virtual void asyncGetDomainRules(const GetDomainRulesParams& params, OnGetDomainRules handler) const = 0;
};

using RepositoryPtr = std::shared_ptr<Repository>;

} // namespace furita
