import requests
from mail.ghost.bin.config import StatfaceConfig


class StatfaceProxy(object):
    def __init__(self):
        self.config = StatfaceConfig()

    def send_json_data(self, json_data, project_path):
        response = requests.post(
            "{}/_api/report/data/{}/{}".format(self.config.host, self.config.path_prefix, project_path),
            params={"scale": self.config.scale},
            headers={"Authorization": "OAuth {}".format(self.config.oauth_token)},
            json={"data": json_data}
        )
        return response
