from mail.ghost.lib.register import register
from mail.ghost.lib.calculator import IResourceCalculator
from mail.ghost.lib.utils import sum_elementwise, total_days
from mail.ghost.lib.conductor_proxy import ConductorProxy
from mail.ghost.calculators.disk.utils.utils import make_golovan_context

import logging
from infra.yasm.yasmapi.hist import RetryLimitExceeded


@register
class DiskMachineSpaceCalculator(IResourceCalculator):
    def __init__(self):
        conductor_proxy = ConductorProxy()
        self.hosts = conductor_proxy.get_hosts("disk_all")

    def get_used_space(self):
        total_used_space = [0] * total_days(self.time_interval)

        for host in self.hosts:
            try:
                value = self.get_resource_utilization_from_golovan(host, make_golovan_context("machine_used_space"))
                total_used_space = sum_elementwise(total_used_space, value)
            except RetryLimitExceeded:
                logger = logging.getLogger(__name__)
                logger.exception("Retry limit exceeded for host {}".format(host))
                continue

        return total_used_space

    def get_space_quota(self):
        total_space_quota = [0] * total_days(self.time_interval)

        for host in self.hosts:
            try:
                value = self.get_resource_utilization_from_golovan(host, make_golovan_context("machine_space_quota"))
                total_space_quota = sum_elementwise(total_space_quota, value)
            except RetryLimitExceeded:
                logger = logging.getLogger(__name__)
                logger.exception("Retry limit exceeded for host {}".format(host))
                continue

        return total_space_quota

    def get_resources(self):
        resources = {
            "used": self.get_used_space(),
            "quota": self.get_space_quota()
        }
        return resources

    def get_statface_project_path(self):
        return ""
