from mail.ghost.lib.register import register
from mail.ghost.lib.calculator import IResourceCalculator
from mail.ghost.lib.utils import sum_elementwise, total_days
from mail.ghost.calculators.disk.utils.qloud_client import DiskQloudClient
from mail.ghost.calculators.disk.utils.utils import make_golovan_context


@register
class DiskQloudCpuCalculator(IResourceCalculator):
    def __init__(self):
        self.qloud_client = DiskQloudClient()

    def get_used_cpu(self):
        environments = self.qloud_client.get_environments()
        total_used_cpu = [0] * total_days(self.time_interval)

        for environment in environments:
            value = self.get_resource_utilization_from_golovan("QLOUD",
                                                               make_golovan_context("qloud_used_cpu", environment))
            total_used_cpu = sum_elementwise(total_used_cpu, value)

        return total_used_cpu

    def get_cpu_limit(self):
        return [self.qloud_client.get_cpu_quota()] * total_days(self.time_interval)

    def get_resources(self):
        resources = {
            "used": self.get_used_cpu(),
            "quota": self.get_cpu_limit()
        }
        return resources

    def get_statface_project_path(self):
        return "Disk/QLOUD/CPU"
