from os import environ


class DispenserProxyConfig(object):
    def __init__(self):
        self.host = "https://dispenser.yandex-team.ru"
        self.cluster = "db"
        self.oauth_token = environ['DISPENSER_TOKEN']

mdb_folder_id = {
    "prod": "fooei3thuvtsu9euikgu",
    "corp": "foont1sfa38t5dcqk11h"
}

# теги для паттернов контекстов в головане
golovan_context_pattern = {
    # контекст в головане для used space у mds
    "mds_used_space": "itype=mdscloud; ctype=prestable,production; prj={}:conv(mastermind-namespaces.stats.effective_used_space_axxx, Ti)",
    # контекст в головане для used_lrc у mds
    "mds_used_lrc": "itype=mdscloud; ctype=prestable,production; prj={}:conv(mastermind-namespaces.stats.effective_used_lrc_space_axxx, Ti)",
    # контекст в головане для space quota у mds
    "mds_space_quota": "itype=mdscloud; ctype=prestable,production; prj={}:conv(mastermind-namespaces.stats.space_limit_axxx, Ti)",

    # контекст в головане для used space железных и железных контейнерных баз
    "xdb_machine_used_space": "itype=mailpostgresql; tier=primary:push-disk-used_bytes_pgdata_vmmv",
    # контекст в головане для used space облачных баз
    "xdb_cloud_used_space": "itype=mailpostgresql; prj={}; tier=primary:push-disk-used_bytes_pgdata_vmmv",

    # контекст в головане для space quota железных баз
    "xdb_machine_space_quota": "itype=mailpostgresql; tier=primary:push-disk-total_bytes_pgdata_vmmv",
    # контекст в головане для space quota облачных баз
    "xdb_cloud_space_quota": "itype=mailpostgresql; prj={}; tier=primary:push-disk-total_bytes_pgdata_vmmv",

    # контекст в головане для used memory проектов в qloud
    "qloud_used_mem": "itype=qloud; prj={}:portoinst-anon_usage_gb_tmmv",
    # memory quota для проектов в qloud берутся из api qloud

    # контекст в головане для used cpu проектов в qloud
    "qloud_used_cpu": "itype=qloud; prj={}:portoinst-cpu_usage_cores_tmmv",
    # cpu limit для проектов в qloud берутся из api qloud

    # контекст в головане для used cpu железных баз
    "machine_used_cpu": "itype=common:havg(cpu-usage_cores_hgram)",
    # контекст в головане для used cpu железных контейнерных баз
    "container_used_cpu": "itype=mdbdom0; prj={}:portoinst-cpu_usage_cores_tmmv",
    # контекст в головане для used cpu облачных баз
    "cloud_used_cpu": "itype=mdbdom0; prj={}:portoinst-cpu_usage_cores_tmmv",

    # cpu limit у железных баз считается по своей логике
    # контекст в головане для cpu limit железных контейнерных баз
    "container_cpu_limit": "itype=mdbdom0; prj={}:portoinst-cpu_limit_cores_tmmv",
    # контекст в головане для cpu limit облачных баз
    "cloud_cpu_limit": "itype=mdbdom0; prj={}:portoinst-cpu_limit_cores_tmmv",

    # контекст в головане для used io ops контейнерных баз
    "container_used_io_ops": "itype=mdbdom0; prj={}; tier=primary:sum(portoinst-io_read_fs_bytes_tmmv,portoinst-io_write_fs_bytes_tmmv)",
    # контекст в головане для used io ops облачных баз
    "cloud_used_io_ops": "itype=mdbdom0; prj={}; tier=primary:sum(portoinst-io_read_fs_bytes_tmmv,portoinst-io_write_fs_bytes_tmmv)",

    # контекст в головане для io ops limit контейнерных баз
    "container_io_ops_limit": "itype=mdbdom0; prj={}; tier=primary:portoinst-io_limit_bytes_tmmv",
    # контекст в головане для io ops limit облачных баз
    "cloud_io_ops_limit": "itype=mdbdom0; prj={}; tier=primary:portoinst-io_limit_bytes_tmmv"
}
