from mail.ghost.lib.register import register
from mail.ghost.lib.calculator import IResourceCalculator
from mail.ghost.calculators.mail.utils.utils import make_golovan_context


@register
class MailMdsSpaceCalculator(IResourceCalculator):
    def get_resources(self):
        resources = {
            "used_mail":
                self.get_resource_utilization_from_golovan("CON", make_golovan_context("mds_used_space", "mail")),
            "used_spam":
                self.get_resource_utilization_from_golovan("CON", make_golovan_context("mds_used_space", "mail-spam")),
            "used_tmp":
                self.get_resource_utilization_from_golovan("CON", make_golovan_context("mds_used_space", "mail-tmp")),
            "quota":
                self.get_resource_utilization_from_golovan("CON", make_golovan_context("mds_space_quota", "mail")),
            "used_lrc":
                self.get_resource_utilization_from_golovan("CON", make_golovan_context("mds_used_lrc", "mail"))
        }
        return resources

    def get_statface_project_path(self):
        return "Mail/MDS/HDD"


@register
class MailCorpMdsSpaceCalculator(IResourceCalculator):
    def get_resources(self):
        resources = {
            "used_mailcorp":
                self.get_resource_utilization_from_golovan("CON", make_golovan_context("mds_used_space", "mail-yt")),
            "used_mailcorp_spam":
                self.get_resource_utilization_from_golovan("CON",
                                                           make_golovan_context("mds_used_space", "mail-yt-spam")),
            "used_mailcorp_tmp":
                self.get_resource_utilization_from_golovan("CON",
                                                           make_golovan_context("mds_used_space", "mail-yt-tmp")),
            "quota":
                self.get_resource_utilization_from_golovan("CON", make_golovan_context("mds_space_quota", "mail"))
        }
        return resources

    def get_statface_project_path(self):
        return ""
