import requests
import json
from mail.ghost.calculators.mail.cfg.config import DispenserProxyConfig


class DispenserProxy(object):
    def __init__(self):
        self.config = DispenserProxyConfig()

    def get_mdb_quota(self):
        response = requests.get(
            "{}/{}/api/v1/quotas".format(self.config.host, self.config.cluster),
            params={"project": "mailmetabase", "resource": "/mdb/ssd"},
            headers={"Authorization": "OAuth {}".format(self.config.oauth_token)}
        )
        response = json.loads(response.text)
        return response["result"][0]["max"]["value"]
