from mail.ghost.lib.conductor_proxy import ConductorProxy


class MailConductorProxy(object):
    def __init__(self):
        self.conductor_proxy = ConductorProxy()

    def get_hosts(self):
        return self.conductor_proxy.get_hosts("mail_xdb")

    def get_shard_id(self, host):
        """На примере хоста xdb301e.mail.yandex.net вернет 301"""
        return int(host.split(".")[0][3:-1])

    def get_shard(self, host):
        """На примере хоста xdb301e.mail.yandex.net вернет xdb301"""
        return host.split(".")[0][:-1]

    def is_corp(self, host):
        return 1001 <= self.get_shard_id(host) <= 1099

    def is_container(self, host):
        return 400 <= self.get_shard_id(host) <= 599

    def get_machine_hosts(self):
        hosts = self.get_hosts()
        machine_hosts = [host for host in hosts
                         if not self.is_container(host)
                         and not self.is_corp(host)]
        return machine_hosts

    def get_container_hosts(self):
        hosts = self.get_hosts()
        container_hosts = [host for host in hosts
                           if self.is_container(host)]
        return container_hosts

    def get_container_shards(self):
        return {self.get_shard(host) for host in self.get_container_hosts()}
