from mail.ghost.lib.register import register
from mail.ghost.lib.calculator import IResourceCalculator
from mail.ghost.lib.utils import sum_elementwise, total_days
from mail.ghost.calculators.mail.utils.mail_conductor_proxy import MailConductorProxy
from mail.ghost.calculators.mail.utils.utils import make_golovan_context
from mail.ghost.calculators.mail.cfg.config import mdb_folder_id


@register
class MailXDBCpuCalculator(IResourceCalculator):
    def __init__(self):
        conductor_proxy = MailConductorProxy()
        self.machine_hosts = conductor_proxy.get_machine_hosts()
        self.container_shards = conductor_proxy.get_container_shards()

    def get_used_cpu(self):
        total_used_cpu = [0] * total_days(self.time_interval)

        # получаем из голована утилизацию cpu железных бд
        for host in self.machine_hosts:
            value = self.get_resource_utilization_from_golovan(host, make_golovan_context("machine_used_cpu"))
            total_used_cpu = sum_elementwise(total_used_cpu, value)

        # получаем из голована утилизацию cpu контейнерных бд
        for shard in self.container_shards:
            value = self.get_resource_utilization_from_golovan("CON", make_golovan_context("container_used_cpu", shard))
            total_used_cpu = sum_elementwise(total_used_cpu, value)

        # получаем из голована утилизацию cpu облачных бд
        value = self.get_resource_utilization_from_golovan("CON", make_golovan_context("cloud_used_cpu", mdb_folder_id["prod"]))
        total_used_cpu = sum_elementwise(total_used_cpu, value)

        return total_used_cpu

    def get_cpu_limit(self):
        # на каждой неконтейнерной базе по 32
        total_cpu_limit = [0] * total_days(self.time_interval)

        # получаем из голована лимит cpu контейнерных бд
        for shard in self.container_shards:
            value = self.get_resource_utilization_from_golovan("CON",
                                                               make_golovan_context("container_cpu_limit", shard))
            total_cpu_limit = sum_elementwise(total_cpu_limit, value)

        # получаем из голована лимит cpu облачных бд
        value = self.get_resource_utilization_from_golovan("CON", make_golovan_context("cloud_cpu_limit", mdb_folder_id["prod"]))
        total_cpu_limit = sum_elementwise(total_cpu_limit, value)

        return sum_elementwise(total_cpu_limit, [len(self.machine_hosts) * 32] * total_days(self.time_interval))

    def get_resources(self):
        resources = {
            "used": self.get_used_cpu(),
            "quota": self.get_cpu_limit()
        }
        return resources

    def get_statface_project_path(self):
        return "Mail/DB/CPU"


@register
class MailCorpXDBCpuCalculator(IResourceCalculator):
    def get_used_cpu(self):

        # получаем из голована утилизацию cpu облачных бд
        total_used_cpu = self.get_resource_utilization_from_golovan("CON", make_golovan_context("cloud_used_cpu", mdb_folder_id["corp"]))

        return total_used_cpu

    def get_cpu_limit(self):

        # получаем из голована лимит cpu облачных бд
        total_cpu_limit = self.get_resource_utilization_from_golovan("CON", make_golovan_context("cloud_cpu_limit", mdb_folder_id["corp"]))

        return total_cpu_limit

    def get_resources(self):
        resources = {
            "used": self.get_used_cpu(),
            "quota": self.get_cpu_limit()
        }
        return resources

    def get_statface_project_path(self):
        return "Mail/DB/CPU_corp"
