from mail.ghost.lib.register import register
from mail.ghost.lib.calculator import IResourceCalculator
from mail.ghost.lib.utils import sum_elementwise, total_days
from mail.ghost.calculators.mail.utils.mail_conductor_proxy import MailConductorProxy
from mail.ghost.calculators.mail.utils.utils import make_golovan_context


@register
class MailXDBIOpsCalculator(IResourceCalculator):
    def get_used_cpu(self):
        total_used_io_ops = [0] * total_days(self.time_interval)

        container_shards = MailConductorProxy().get_container_shards()
        for shard in container_shards:
            value = self.get_resource_utilization_from_golovan("CON", make_golovan_context("container_used_io_ops", shard))
            total_used_io_ops = sum_elementwise(total_used_io_ops, value)

        value = self.get_resource_utilization_from_golovan("CON", make_golovan_context("cloud_used_io_ops", 'fooei3thuvtsu9euikgu'))
        total_used_io_ops = sum_elementwise(total_used_io_ops, value)

        return total_used_io_ops

    def get_cpu_limit(self):
        total_io_ops_limit = [0] * total_days(self.time_interval)

        container_shards = MailConductorProxy().get_container_shards()
        for shard in container_shards:
            value = self.get_resource_utilization_from_golovan("CON", make_golovan_context("container_io_ops_limit", shard))
            total_io_ops_limit = sum_elementwise(total_io_ops_limit, value)

        value = self.get_resource_utilization_from_golovan("CON", make_golovan_context("cloud_io_ops_limit", 'fooei3thuvtsu9euikgu'))
        total_io_ops_limit = sum_elementwise(total_io_ops_limit, value)

        return total_io_ops_limit

    def get_resources(self):
        resources = {
            "used": self.get_used_cpu(),
            "quota": self.get_cpu_limit()
        }
        return resources

    def get_statface_project_path(self):
        # проект в statface еще не создан
        return ""
