from mail.ghost.lib.register import register
from mail.ghost.lib.calculator import IResourceCalculator
from mail.ghost.lib.utils import sum_elementwise, total_days
from mail.ghost.calculators.mail.utils.mail_conductor_proxy import MailConductorProxy
from mail.ghost.calculators.mail.utils.utils import make_golovan_context
from mail.ghost.calculators.mail.cfg.config import mdb_folder_id


@register
class MailXDBSpaceCalculator(IResourceCalculator):
    def __init__(self):
        # получаем из кондуктора список железных хостов
        conductor_proxy = MailConductorProxy()
        self.hosts = conductor_proxy.get_machine_hosts() + conductor_proxy.get_container_hosts()

    def get_used_space(self):
        total_used_space = [0] * total_days(self.time_interval)

        # получаем из голована утилизацию места железных бд
        for host in self.hosts:
            value = self.get_resource_utilization_from_golovan(host, make_golovan_context("xdb_machine_used_space"))
            total_used_space = sum_elementwise(total_used_space, value)

        # получаем из голована утилизацию места облачных бд
        value = self.get_resource_utilization_from_golovan("CON", make_golovan_context("xdb_cloud_used_space", mdb_folder_id["prod"]))
        total_used_space = sum_elementwise(total_used_space, value)

        return total_used_space

    def get_space_quota(self):
        total_space_quota = [0] * total_days(self.time_interval)

        # получаем из голована квоту места железных бд
        for host in self.hosts:
            value = self.get_resource_utilization_from_golovan(host, make_golovan_context("xdb_machine_space_quota"))
            total_space_quota = sum_elementwise(total_space_quota, value)

        # получаем из голована квоту места облачных бд
        value = self.get_resource_utilization_from_golovan("CON", make_golovan_context("xdb_cloud_space_quota", mdb_folder_id["prod"]))
        total_space_quota = sum_elementwise(total_space_quota, value)

        return total_space_quota

    def get_resources(self):
        resources = {
            "used": self.get_used_space(),
            "quota": self.get_space_quota()
        }
        return resources

    def get_statface_project_path(self):
        return "Mail/DB/SSD"


@register
class MailCorpXDBSpaceCalculator(IResourceCalculator):
    def get_used_space(self):

        # получаем из голована утилизацию места облачных бд
        total_used_space = self.get_resource_utilization_from_golovan("CON", make_golovan_context("xdb_cloud_used_space", mdb_folder_id["corp"]))

        return total_used_space

    def get_space_quota(self):

        # получаем из голована квоту места облачных бд
        total_space_quota = self.get_resource_utilization_from_golovan("CON", make_golovan_context("xdb_cloud_space_quota", mdb_folder_id["corp"]))

        return total_space_quota

    def get_resources(self):
        resources = {
            "used": self.get_used_space(),
            "quota": self.get_space_quota()
        }
        return resources

    def get_statface_project_path(self):
        return "Mail/DB/SSD_corp"
