from mail.ghost.lib.calculator import IResourceCalculator
from mail.ghost.lib.register import register


@register
class MailYTSpaceCalculator(IResourceCalculator):
    def __init__(self):
        self.cgi_params = {
            "project": "yt",
            "service": "accounts",
            "dashboard": "yt-account-limits-media",
            "l.account": "mail-logs",
            "l.medium": "default"
        }

    def get_used_space(self):
        self.cgi_params["cluster"] = "hahn"
        self.cgi_params["l.sensor"] = "disk_space_in_gb"
        total_used_space = self.get_resource_utilization_from_solomon(self.cgi_params)
        return total_used_space

    def get_space_quota(self):
        self.cgi_params["cluster"] = "hahn"
        self.cgi_params["l.sensor"] = "disk_space_limit_in_gb"
        total_space_quota = self.get_resource_utilization_from_solomon(self.cgi_params)
        return total_space_quota

    def get_resources(self):
        resources = {
            "used": self.get_used_space(),
            "quota": self.get_space_quota()
        }
        return resources

    def get_statface_project_path(self):
        return ""
