import itertools
from mail.ghost.lib.register import register
from mail.ghost.lib.calculator import IResourceCalculator
from mail.ghost.lib.utils import sum_elementwise, total_days
from mail.ghost.calculators.messenger.cfg.config import qloud_itypes, qloud_ctypes
from mail.ghost.calculators.messenger.utils.utils import make_golovan_context


@register
class MessengerRtcMemoryCalculator(IResourceCalculator):
    def get_used_cpu(self):
        total_used_cpu = [0] * total_days(self.time_interval)

        for itype, ctype in itertools.product(qloud_itypes, qloud_ctypes):
            value = self.get_resource_utilization_from_golovan("ASEARCH", make_golovan_context("qloud_used_memory", itype, ctype))
            total_used_cpu = sum_elementwise(total_used_cpu, value)

        return total_used_cpu

    def get_cpu_limit(self):
        total_used_cpu = [0] * total_days(self.time_interval)

        for itype, ctype in itertools.product(qloud_itypes, qloud_ctypes):
            value = self.get_resource_utilization_from_golovan("ASEARCH", make_golovan_context("qloud_memory_quota", itype, ctype))
            total_used_cpu = sum_elementwise(total_used_cpu, value)

        return total_used_cpu

    def get_resources(self):
        resources = {
            "used": self.get_used_cpu(),
            "quota": self.get_cpu_limit()
        }
        return resources

    def get_statface_project_path(self):
        return "Mssngr/RTC/RAM"
