from os import environ


class NannyProxyConfig(object):
    def __init__(self):
        self.host = "https://nanny.yandex-team.ru"
        self.oauth_token = environ['NANNY_TOKEN']


class GencfgProxyConfig(object):
    def __init__(self):
        self.host = "https://api.gencfg.yandex-team.ru"


# теги для паттернов контекстов в головане
golovan_context_pattern = {
    # контекст в головане для used cpu персонального поиска по почте
    "mail_used_cpu": "itype=lucene; ctype=prestable,prod; prj=mail-main:portoinst-cpu_usage_cores_tmmv",
    # контекст в головане для used cpu персонального поиска по диску
    "disk_used_cpu": "itype=bacchus; ctype=prestable,prod; prj=disk-main:portoinst-cpu_usage_cores_tmmv",

    # контекст в головане для used mem персонального поиска по почте
    "mail_used_mem": "itype=lucene; ctype=prestable,prod; prj=mail-main:portoinst-memory_usage_gb_tmmv",
    # контекст в головане для used mem персонального поиска по диску
    "disk_used_mem": "itype=bacchus; ctype=prestable,prod; prj=disk-main:portoinst-memory_usage_gb_tmmv",
}

# теги для набора групп в няне
nanny_groups = {
    "mail":
        ["mail_search_prestable", "mail_search_prod"],
    "disk":
        ["disk_search_backend_prestable", "disk_search_backend_prod"]
}
