from mail.ghost.lib.register import register
from mail.ghost.lib.calculator import IResourceCalculator
from mail.ghost.lib.utils import total_days
from mail.ghost.calculators.personal_searches.utils.nanny_proxy import NannyProxy
from mail.ghost.calculators.personal_searches.utils.gencfg_proxy import GencfgProxy
from mail.ghost.calculators.personal_searches.utils.utils import make_golovan_context
from mail.ghost.calculators.personal_searches.cfg.config import nanny_groups


@register
class PersonalSearchesMailMemoryCalculator(IResourceCalculator):
    def get_used_memory(self):
        return self.get_resource_utilization_from_golovan("ASEARCH", make_golovan_context("mail_used_mem"))

    def get_memory_quota(self):
        total_memory_quota = 0
        gencfg_proxy = GencfgProxy()
        nanny_proxy = NannyProxy()

        for nanny_group in nanny_groups["mail"]:
            gencfg_groups = nanny_proxy.get_gencfg_groups_by_nanny_group(nanny_group)
            for group in gencfg_groups:
                total_memory_quota += gencfg_proxy.get_gencfg_group_total_memory_limit(group)

        # covert B to GB
        return [total_memory_quota >> 30] * total_days(self.time_interval)

    def get_resources(self):
        resources = {
            "used": self.get_used_memory(),
            "quota": self.get_memory_quota()
        }
        return resources

    def get_statface_project_path(self):
        return "PersonalSearches/Mail/RTC/RAM"
