import requests
import json
from mail.ghost.calculators.personal_searches.cfg.config import GencfgProxyConfig


class GencfgProxy(object):
    def __init__(self):
        self.config = GencfgProxyConfig()

    def get_gencfg_group_instances(self, gencfg_group):
        response = requests.get(
            "{}/trunk/searcherlookup/groups/{}/instances".format(self.config.host, gencfg_group)
        )
        response = json.loads(response.text)
        return response["instances"]

    def get_gencfg_group_total_cpu_limit(self, gencfg_group):
        total_cpu_limit = 0
        instances = self.get_gencfg_group_instances(gencfg_group)

        for instance in instances:
            total_cpu_limit += instance["porto_limits"]["cpu_cores_limit"]

        return total_cpu_limit

    def get_gencfg_group_total_memory_limit(self, gencfg_group):
        total_memory_limit = 0
        instances = self.get_gencfg_group_instances(gencfg_group)

        for instance in instances:
            total_memory_limit += instance["porto_limits"]["memory_limit"]

        return total_memory_limit
