import requests
import json
from mail.ghost.calculators.personal_searches.cfg.config import NannyProxyConfig


class NannyProxy(object):
    def __init__(self):
        self.config = NannyProxyConfig()

    def get_gencfg_groups_by_nanny_group(self, nanny_group):
        response = requests.get(
            "{}/v2/services/{}/runtime_attrs/".format(self.config.host, nanny_group),
            headers={"Authorization": "OAuth {}".format(self.config.oauth_token)}
        )
        response = json.loads(response.text)
        groups = response["content"]["instances"]["extended_gencfg_groups"]["groups"]
        gencfg_groups = set(item["name"] for item in groups)
        return gencfg_groups
