from os import environ


class NannyProxyConfig(object):

    def __init__(self):
        self.host = "https://nanny.yandex-team.ru"
        self.oauth_token = environ['NANNY_TOKEN']


class GencfgProxyConfig(object):

    def __init__(self):
        self.host = "https://api.gencfg.yandex-team.ru"


# теги для паттернов контекстов в головане
golovan_patterns = ["checkform",
                    "checkmessage",
                    "clusterization",
                    "complaint",
                    "frodooborona",
                    "msearchproxy",
                    "soclusterization",
                    "sogeneralshingler",
                    "sologger",
                    "sologgerbackend",
                    "sologgerqueue",
                    "solsa",
                    "sorblbackend",
                    "sorblqueue",
                    "soshingler",
                    "spamstat",
                    "spdaemon",
                    "web"]

golovan_patterns_cpu = [
    "itype=" + i + ":portoinst-cpu_usage_cores_tmmv" for i in golovan_patterns]

golovan_patterns_mem = [
    "itype=" + i + ":portoinst-memory_usage_gb_tmmv" for i in golovan_patterns]

# теги для набора групп в няне
nanny_groups = {
    "so": [
        "checkform",
        "clusterization",
        "general_cache",
        "knn_bot",
        "mail_sosearch_proxy_iva",
        "mail_sosearch_proxy_myt",
        "mail_sosearch_proxy_sas",
        "mail_sosearch_proxy_vla",
        "so_checkform_testing",
        "so_checkmessage",
        "so_checkmessage_testing",
        "so_complaints",
        "so_fraud",
        "so_fraud_testing",
        "so_freemail_iva",
        "so_freemail_myt",
        "so_freemail_sas",
        "so_freemail_vla",
        "so_frodooborona",
        "so_frodooborona_testing",
        "so_general_abuse",
        "so_general_activity",
        "so_general_sender_testing",
        "so_logger_backend",
        "so_logger_backend_testing",
        "so_logger_queue",
        "so_lsa",
        "so_msearch_proxy",
        "so_rbl_backend",
        "so_rbl_queue",
        "so_shinglers_count_in",
        "so_shinglers_count_out",
        "so_spamstat",
        "so_urlreputation",
        "so_web",
        "sp_apphost_test",
        "spdaemon-in-iva",
        "spdaemon-in-myt",
        "spdaemon-in-sas",
        "spdaemon-in-vla",
        "spdaemon-prod-corp-iva",
        "spdaemon-prod-corp-myt",
        "spdaemon-prod-corp-sas",
        "spdaemon-prod-corp-vla",
        "spdaemon-prod-out-iva",
        "spdaemon-prod-out-myt",
        "spdaemon-prod-out-sas",
        "spdaemon-prod-out-vla",
        "spdaemon-testing-corp",
        "spdaemon-testing-in",
        "spdaemon-testing-mail-in",
        "spdaemon-testing-mail-out",
        "spdaemon-testing-out"
    ]
}
