from mail.ghost.lib.register import register
from mail.ghost.lib.calculator import IResourceCalculator
from mail.ghost.lib.utils import total_days, sum_elementwise_from_single_list
from mail.ghost.calculators.personal_searches.utils.nanny_proxy import NannyProxy
from mail.ghost.calculators.personal_searches.utils.gencfg_proxy import GencfgProxy
from mail.ghost.calculators.so.cfg.config import nanny_groups, golovan_patterns_cpu


@register
class SOCpuCalculator(IResourceCalculator):
    def get_used_cpu(self):
        cpu_usage = []
        for pattern in golovan_patterns_cpu:
            cpu_usage.append(self.get_resource_utilization_from_golovan("ASEARCH", pattern))
        return sum_elementwise_from_single_list(cpu_usage)

    def get_cpu_limit(self):
        total_cpu_limit = 0
        gencfg_proxy = GencfgProxy()
        nanny_proxy = NannyProxy()

        for nanny_group in nanny_groups["so"]:
            gencfg_groups = nanny_proxy.get_gencfg_groups_by_nanny_group(nanny_group)
            for group in gencfg_groups:
                total_cpu_limit += gencfg_proxy.get_gencfg_group_total_cpu_limit(group)

        return [total_cpu_limit] * total_days(self.time_interval)

    def get_resources(self):
        resources = {
            "used": self.get_used_cpu(),
            "quota": self.get_cpu_limit()
        }
        return resources

    def get_statface_project_path(self):
        return "SO/RTC/CPU"
