from mail.ghost.lib.register import register
from mail.ghost.lib.calculator import IResourceCalculator
from mail.ghost.lib.utils import total_days, sum_elementwise_from_single_list
from mail.ghost.calculators.personal_searches.utils.nanny_proxy import NannyProxy
from mail.ghost.calculators.personal_searches.utils.gencfg_proxy import GencfgProxy
from mail.ghost.calculators.so.cfg.config import nanny_groups, golovan_patterns_mem


@register
class SOMemoryCalculator(IResourceCalculator):
    def get_used_memory(self):
        mem_usage = []
        for pattern in golovan_patterns_mem:
            mem_usage.append(self.get_resource_utilization_from_golovan("ASEARCH", pattern))
        return sum_elementwise_from_single_list(mem_usage)

    def get_memory_quota(self):
        total_memory_quota = 0
        gencfg_proxy = GencfgProxy()
        nanny_proxy = NannyProxy()

        for nanny_group in nanny_groups["so"]:
            gencfg_groups = nanny_proxy.get_gencfg_groups_by_nanny_group(nanny_group)
            for group in gencfg_groups:
                total_memory_quota += gencfg_proxy.get_gencfg_group_total_memory_limit(group)

        # covert B to GB
        return [total_memory_quota >> 30] * total_days(self.time_interval)

    def get_resources(self):
        resources = {
            "used": self.get_used_memory(),
            "quota": self.get_memory_quota()
        }
        return resources

    def get_statface_project_path(self):
        return "SO/RTC/RAM"
