from abc import ABCMeta, abstractmethod

from mail.ghost.lib.data_aggregators import get_resource_utilization_from_golovan, get_resource_utilization_from_solomon


class IResourceCalculator(metaclass=ABCMeta):
    dry_run = False
    time_interval = None  # [begin_day, end_day)

    def get_resource_utilization_from_golovan(self, host, context):
        return get_resource_utilization_from_golovan(host, context, self.time_interval)

    def get_resource_utilization_from_solomon(self, cgi_params):
        return get_resource_utilization_from_solomon(cgi_params, self.time_interval)

    @abstractmethod
    def get_resources(self):
        """
        Метод возвращает значение утилизации ресурсов за предыдущий день для одного графика.
        Возвращать следует мап вида {"название поля в statface": "значение утилизации"}.
        Указывать значение fielddate не нужно.
        """

    @abstractmethod
    def get_statface_project_path(self):
        """Метод возвращает путь до проекта в statface. Например, 'Mail/CapacityPlanning/Mail/MDS'"""
