import logging
from socket import timeout
from urllib.error import HTTPError
from retry import retry
from infra.yasm.yasmapi import GolovanRequest
from mail.ghost.lib.config import GolovanProxyConfig


class GolovanProxy(object):
    logger = logging.getLogger(__name__)

    def __init__(self):
        self.config = GolovanProxyConfig()

    @retry((HTTPError, timeout), tries=3, delay=5, logger=logger)
    def get_values(self, host, period, from_timestamp, to_timestamp, context, load_segments):
        response = list(GolovanRequest(host, period, from_timestamp, to_timestamp, [context],
                                       load_segments=load_segments, max_retry=self.config.max_retry,
                                       retry_delay=self.config.retry_delay,
                                       explicit_fail=True))
        values = []
        for timestamp, signal_dict in response:
            value = list(signal_dict.values())[0]
            values.append((timestamp, value))

        return values
