import logging
from socket import timeout
from urllib.error import HTTPError
from retry import retry
import requests
import json
from dateutil.parser import parse
from mail.ghost.lib.config import SolomonProxyConfig


class SolomonProxy(object):
    logger = logging.getLogger(__name__)

    def __init__(self):
        self.config = SolomonProxyConfig()

    @retry((HTTPError, timeout), tries=3, delay=10, logger=logger)
    def get_values(self, cgi_params):
        cgi_params["who"] = self.config.who_cgi_field

        response = requests.get(
            "{}/data-api/get".format(self.config.host),
            params=cgi_params,
            headers={"Authorization": "OAuth {}".format(self.config.oauth_token)}
        )

        if response.status_code != 200:
            return RuntimeError('Response status code differs from 200: {}'.format(response.status_code))

        sensors = json.loads(response.text)["sensors"]

        values = []
        for sensor in sensors:
            for value in sensor["values"]:
                # convert ISO8601 to timestamp
                ts = parse(value["ts"][:-1]).timestamp()
                values.append((ts, value["value"]))
        return values
