import requests

from .utils import retry_session, http_request


class SharpeiError(Exception):
    pass


class Sharpei(object):
    def __init__(self, url, user, pwd, session=retry_session(), timeout=10):
        self.url = url
        self.timeout = timeout
        self.session = session
        self.user = user
        self.pwd = pwd

    def get_conn_info(self, uid):
        sharpei_params = {'uid': uid, 'mode': "read_only", 'format': 'json'}
        try:
            resp = http_request(url=self.url, session=self.session, timeout=self.timeout, params=sharpei_params)
            return self.parse_addr(resp.json(), self.user, self.pwd)
        except (ValueError, AttributeError, requests.HTTPError) as err:
            raise SharpeiError(err)

    @staticmethod
    def parse_addr(json, user, pwd):
        try:
            dbs = json.get('databases', [])
            address = next(db['address'] for db in dbs if db.get('status', 'unknown') == 'alive')
            address['user'] = user
            address['password'] = pwd
            return 'host={host} port={port} dbname={dbname} user={user} password={password}'.format(**address)
        except KeyError as err:
            raise SharpeiError('problem with {0} in {1}'.format(err, json))
        except StopIteration:
            raise SharpeiError("available replica is not found")
