# -*- coding: utf-8 -*-


class BaseHandler(object):
    def process(self, header, data):
        raise NotImplementedError()

    def flush(self, force=False):
        return True

    def monitor(self, policy, state):
        """
        Проверка для мониторинга. Возвращает признак окончания проверки, статус мониторинга для отображения
        и сообщение мониторинга (актуальны, если выставлен признак окончания проверки)
        """
        return False, None, None
