# -*- coding: utf-8 -*-
import logging

from ..queues.exceptions import (
    FullQueueException,
    EmptyQueueException,
)
from .base import Worker
from .exceptions import (
    WorkerIgnorableWithAckError,
    WorkerIgnorableError,
)


log = logging.getLogger('runner.workers.basic')


class BasicWorker(Worker):
    GET_TASK_TIMEOUT = 1
    PUT_ACK_TIMEOUT = 5

    def read_task(self):
        try:
            return self.tasks_queue.get_timeout(self.GET_TASK_TIMEOUT)
        except EmptyQueueException:
            return None

    def ack_task(self, task):
        try:
            self.ack_queue.put_timeout(task.id_, self.PUT_ACK_TIMEOUT)
        except FullQueueException:
            log.warning(u'Ack queue', task.id_)
            return None

    def handle_task(self, task):
        raise NotImplementedError()

    def loop(self):
        while True:
            task = self.read_task()
            if not task:
                continue
            try:
                self.handle_task(task)
            except WorkerIgnorableWithAckError, e:
                log.warning(e)
            except WorkerIgnorableError, e:
                log.error(e)
                continue
            self.ack_task(task)
