# -*- coding: utf-8 -*-

import os


def config(log_path):
    return {
        'version': 1,
        'disable_existing_loggers': False,
        'formatters': {
            'default': {
                'format': '%(asctime)s [%(levelname)s] %(process)d %(name)s %(message)s',
            },
            'event': {
                'format': '%(message)s',
            }
        },
        'root': {
            'handlers': [
                'logbroker_client.log',
                'exception'
            ],
            'level': 'DEBUG'
        },
        'handlers': {
            'console': {
                'class': 'logging.StreamHandler',
                'level': 'DEBUG',
                'formatter': 'default',
            },
            'exception': {
                'class': 'logging.FileHandler',
                'filename': log_path + 'exception.log',
                'level': 'ERROR',
                'formatter': 'default',
            },
            'logbroker_client.log': {
                'class': 'logging.FileHandler',
                'filename': log_path + 'consumer.log',
                'level': os.environ.get('CONSUMER_LOGLEVEL', 'WARNING'),
                'formatter': 'default',
            },
            'stats.log': {
                'class': 'logging.FileHandler',
                'filename': log_path + 'stats.log',
                'level': 'INFO',
                'formatter': 'event',
            },
        },
        'loggers': {
            "logbroker": {
                "level": os.environ.get('CLIENT_LOGLEVEL', 'WARNING'),
                "handlers": ["logbroker_client.log"],
                "propagate": False
            },
            "kazoo": {
                "level": os.environ.get('CLIENT_LOGLEVEL', 'WARNING'),
                "handlers": ["logbroker_client.log"],
                "propagate": False
            },
            "stats": {
                "level": 'INFO',
                "handlers": ["stats.log"],
                "propagate": False
            },
        }

    }


def config_stdout(s=None):
    return {
        'version': 1,
        'disable_existing_loggers': False,
        'formatters': {
            'default': {
                # 20539 2015-06-10 17:28:11,089 logbroker       DEBUG      Packed: 403 Unpacked: 836
                'format': '%(asctime)s [%(levelname)s] %(process)d %(name)s %(message)s',
            },
            'event': {
                'format': '%(message)s',
            }
        },
        'root': {
            'handlers': [
                'console',
                'logbroker_client_common.handler'
            ],
            'level': 'DEBUG'
        },
        'handlers': {
            'logbroker_client_common.handler': {
                'class': 'logging.StreamHandler',
                'level': os.environ.get('CONSUMER_LOGLEVEL', 'DEBUG'),
                'formatter': 'default',
            },
            'console': {
                'class': 'logging.StreamHandler',
                'level': os.environ.get('CONSUMER_LOGLEVEL', 'DEBUG'),
                'formatter': 'default',
            },
        },
        'loggers': {}
    }
