# encoding: utf-8
from __future__ import unicode_literals

import logging

import ahocorasick

from logbroker_processors.app_metrics.metrika_mobile_log_enums import METRIKA_MOBILE_LOG_ENUMS

log = logging.getLogger(__name__)


class TSKV(object):
    def fix_string(self, string):
        if isinstance(string, str):
            string = string.decode('utf-8', errors='ignore')
        return string

    def to_dict(self, string):
        d = dict()
        # valid tskv looks like:
        # 'tskv      key=value       key1=value1'
        string = string.strip()
        if not string:
            return None
        string = self.fix_string(string)
        if string.startswith('tskv'):
            # chop off leading 'tskv' substring
            for field in string.split('\t')[1:]:
                kv = field.split('=', 1)
                if len(kv) > 1:
                    d[kv[0]] = kv[1]
                else:
                    # Emtpy field -- probably a runaway tab. Skip it.
                    continue
        else:
            return None
        return d


class AM_TSKV(TSKV):
    """
    Парсер записей логов АппМетрики
    """
    filters = (
        b'\tEventType=EVENT_ERROR',
        b'\tEventName=EVENTUS',
        b'\tEventType=EVENT_PROTOBUF_ERROR',
        b'\tEventType=EVENT_CRASH',
        b'\tEventType=EVENT_PROTOBUF_CRASH',
        b'\tEventType=EVENT_PUSH_TOKEN',
    )

    def to_dict(self, string):
        for f in self.filters:
            if f in string:
                string = self.fix_string(string)
                return super(AM_TSKV, self).to_dict(string)
        return None


class NO_PARSING(object):
    event_types = {'EVENT_PUSH_TOKEN', 'EVENT_PROTOBUF_CRASH', 'EVENT_CRASH', 'EVENT_PROTOBUF_ERROR', 'EVENT_ERROR'}

    def to_dict(self, frame):
        event_type = METRIKA_MOBILE_LOG_ENUMS['EventType'].get(str(frame.EventType))
        if not event_type:
            return None
        event_name = frame.EventName
        if event_type in self.event_types or event_name.startswith('EVENTUS'):
            return {
                'EventType': event_type,
                'EventName': event_name,
                'EventValue': frame.EventValue,
                'EventTimestamp': frame.EventTimestamp,
                'UUID': frame.UUID,
                'AccountID': frame.AccountID,
                'DeviceID': frame.DeviceID,
                'APIKey': frame.APIKey,
                'AppID': frame.AppID,
                'AppPlatform': frame.AppPlatform
            }
        return None


if __name__ == '__main__':
    A = ahocorasick.Automaton()
    for f in ['a', 'b', 'c', 'd']:
        A.add_word(str(f), None)
    A.make_automaton()
    for _ in A.iter(str('pizza')):
        print(_)
    for _ in A.iter(str('pasta')):
        print(_)
