import time
import hashlib
from random import random
from importlib import import_module
from os import environ as env


def reverse_ts(ts, msecs=None, base=(2 ** 64)):
    ms = msecs
    if ms is None:
        # Set it 'RANDOM_NUM' environment variable (for tests)
        # Or a random number (0.0 .. 1.0)
        ms = float(env.get('RANDOM_NUM', random()))

    if isinstance(ts, time.struct_time):
        ts_float = time.mktime(ts) + float(ms)
    elif isinstance(ts, float):
        ts_float = ts
    elif isinstance(ts, int):
        ts_float = ts + ms
    else:
        raise TypeError("%s.reverse_ts(): argument 1 must be float, int, or time.time_struct!" % __name__)
    return base - int((ts_float) * 1000)


def md5(string):
    return hashlib.md5(string).hexdigest()


def filter_dict(input_dict, keys_to_remove):
    if not isinstance(keys_to_remove, list):
        raise TypeError("%s.filter_dict(): second argument must be a list!" % __name__)
    keep_keys = set(input_dict.keys()) - set(keys_to_remove)
    return {key: input_dict[key] for key in keep_keys}


def put_cf(source_dict, cf='cf'):
    if not isinstance(source_dict, dict):
        raise TypeError("%s.prepend_cf(): argument 1 must be a dict!" % __name__)
    new_dict = {}
    for key, value in source_dict.items():
        new_dict['%s:%s' % (cf, key)] = value
    if not new_dict:
        raise ValueError("Parsed dictionary is empty!")
    return new_dict


def importobj(objpath):
    module_path, obj_name = objpath.rsplit('.', 1)
    module = import_module(module_path)
    return getattr(module, obj_name)


def chunk_it(iterable, size=100):
    chunk = []
    for i, el in enumerate(iterable, start=1):
        chunk.append(el)

        if i % size == 0:
            yield chunk
            chunk = []

    if chunk:
        yield chunk
