# encoding: utf-8
from __future__ import unicode_literals
from functools import wraps


def retry_on(exc=(Exception,), retries=2):
    def decorator(func):
        @wraps(func)
        def wrapper(self, *args, **kwargs):
            for retry in xrange(1, retries + 1):
                try:
                    return func(self, *args, **kwargs)
                except exc:
                    if retry == retries:
                        raise
        return wrapper
    return decorator
