"""
Actual processing logic is defined in ClickhouseLogProcessor.

For raw data converison rules, see "DDL" classes.

This module is for (sub)processor definitions only.
"""
from logbroker_processors.clickhouse import ClickhouseLogProcessor
from mdb_clickhouse_logs import ddl


class DBaaSLogProcessor(ClickhouseLogProcessor):
    """
    Defines processors specific to DBaaS logs.
    This class is supposed to be called by CommonHandler.
    """
    def __init__(self, **opts):
        super(DBaaSLogProcessor, self).__init__(**opts)
        self.processors = {
            'postgresql': ddl.Postgres(),
            'pgbouncer': ddl.PGBouncer(),
            'pgbouncer_int': ddl.PGBouncer(),
            'pgbouncer_ext': ddl.PGBouncer(),
            'mongod': ddl.Mongod(),
            'mongos': ddl.Mongos(),
            'mongocfg': ddl.Mongocfg(),
            'syslog_auth': ddl.Skip(),
        }
