from .base import BaseProcessor
import logging
import time

log = logging.getLogger(__name__)


class Rpop(BaseProcessor):

    def rpop_sessions(self, header, data):
        assert isinstance(data, dict)

        # Construct key from session.
        try:
            session_id = data['session']
        except KeyError:
            raise ValueError("unable to get session id from string")

        key = "{ses_id}".format(ses_id=session_id)
        processed_data = self.filter_dict(
            data,
            ['method', 'protocol',
             'request_time', 'service',
             'tskv_format', 'vhost'
             ]
            )

        return {
            'data': processed_data,
            'key': key,
        }

    def rpop_suid_sessions(self, header, data):
        assert isinstance(data, dict)
        # Construct key
        try:
            suid = int(data['suid'])
            ts = time.strptime(data['timestamp'], '%d/%b/%Y:%H:%M:%S')
            action = data['action']
        except KeyError:
            raise ValueError("unable to get message or queue id from string")
        if action not in ['check_server', 'create']:  # skip /api/list and other records.
            raise ValueError

        key = "{suid:020d}_{rev_ts:020d}".format(suid=suid, rev_ts=self.reverse_ts(ts))

        processed_data = self.filter_dict(
            data,
            ['tskv_format', 'postfix_daemon', 'localhost']
            )

        return {
            'data': processed_data,
            'key': key,
        }
