# encoding: utf-8
from __future__ import unicode_literals
import json
import logging
from logbroker_processors.utils import service_base_client

logger = logging.getLogger()


class CollieClient(service_base_client.ServiceBaseClient):
    def feed_uid(self, uid, contacts):
        return self._make_request('/v1/users/{uid}/contacts/emails'.format(uid=uid), method='post', json_body=contacts)


class SenderClient(service_base_client.ServiceBaseClient):
    def __init__(self, host, timeout=15, token=None, account=None):
        super(SenderClient, self).__init__(host, timeout)
        self._token = token
        self._account = account
        self._session.auth = (self._token, '')

    def send_email(self, campaign_slug, uid):
        return self._make_request(
            '/api/0/{account}/transactional/{campaign_slug}/send'.format(
                account=self._account,
                campaign_slug=campaign_slug
            ),
            # Для дедубликации покладки письма
            json_body={
                'headers': json.dumps({'Message-ID': '<welcome-letter>', 'Date': 'Thu, 01 Jan 1970 00:00:00 GMT'}),
                'async': True
            },
            params={'to_yandex_puid': uid}
        )
