create table mailstatsdb.mail_events (
    date Date,
    operation String,
    source Enum8('userjournal'=1),
    own_mail UInt8,
    uid UInt64,
    mid UInt64,
    action_date DateTime,
    tid UInt64,
    email_from String,
    local_from String,
    domain_from String,
    fid UInt64,
    readed_percent UInt8,
    widget String,
    list_id String,
    message_id String,
    x_mailer String,
    x_mailru_msgtype String,
    subject String,
    subject_hash String
) Engine = MergeTree(date, (uid, mid, date, operation, action_date, own_mail), 8192);

CREATE MATERIALIZED VIEW mailstatsdb.mails
Engine = MergeTree(date, (uid, mid, date, action_date, own_mail), 8192)
POPULATE AS
SELECT
    date,
    uid,
    mid,
    action_date,
    own_mail,
    source,
    email_from,
    local_from,
    domain_from,
    list_id,
    message_id,
    x_mailer,
    x_mailru_msgtype,
    subject,
    subject_hash
FROM mailstatsdb.mail_events
WHERE operation = 'receive';
