# encoding: utf-8
from __future__ import unicode_literals

import re

re_split_state = re.compile(r'(?P<key>[-_\w]+)="(?P<value>(?:\\"|\\\\|[^"\\])*)"')


def quote_tskv_value(value):
    if not value:
        return value
    quoted = (
        value
        .replace('\t', r'\t')
        .replace('\n', r'\n')
        .replace('\r', r'\r')
        .replace('\0', r'\0')
        .replace('\\', r'\\')
        .replace('=', r'\=')
    )
    return quoted


def unquote_unicode_value(value):
    # Определяем чем закодирована строка
    if (
        '\\x' in value or
        '\\u' in value or
        '\\U' in value
    ):
        # Экранирование юникода с помощью \xXX, \uXXXX или \UXXXXXX
        if isinstance(value, unicode):
            value = value.encode('utf-8')
        return value.decode('raw_unicode_escape')
    # Обычный UTF-8
    if not isinstance(value, unicode):
        return value.decode('utf-8')
    return value


def unquote_tskv_value(value):
    if not value:
        return value
    if isinstance(value, str):
        value = unicode(value, encoding='utf8')
    return (
        value
        .replace('\\b', '\b')
        .replace('\\f', '\f')
        .replace('\\r', '\r')
        .replace('\\n', '\n')
        .replace('\\t', '\t')
        .replace('\\0', '\0')
        .replace('\\\\\\', '')
        .replace('\\=', '=')
    )


def unescape_state_value(value):
    if not value:
        return value
    return value.replace('\\"', '"').replace('\\\\', '\\')


def parse_state(value):
    if not value:
        return None
    if isinstance(value, basestring):
        values = re_split_state.findall(value)
        result = {x[0]: unescape_state_value(x[1]) for x in values}
        return result
    return None
